{-----------------------------------------------------------------------------
This Software is placed into Publlic Domain and distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied.
The Initial Developer is Martin Waldenburg
(Martin.Waldenburg@T-Online.de).
-----------------------------------------------------------------------------}
unit mwIdToString;

interface

uses mwDelphiLanguageElements;

function IdToString(id: integer): string;

implementation

function IdToString(id: Integer): string;
begin
  Result := 'leUnknown';
  case Id of
    leZero: Result := 'leZero';
    leSpace: Result := 'leSpace';
    leTab: Result := 'leTab';
    leLF: Result := 'leLF';
    leCR: Result := 'leCR';
    leExclam: Result := 'leExclam';
    leDoubleQuote: Result := 'leDoubleQuote';
    leSharp: Result := 'leSharp';
    leDollar: Result := 'leDollar';
    lePercent: Result := 'lePercent';
    leAmpersand: Result := 'leAmpersand';
    leApostrophe: Result := 'leApostrophe';
    leRoundOpen: Result := 'leRoundOpen';
    leRoundClose: Result := 'leRoundClose';
    leAsterisk: Result := 'leAsterisk';
    lePlus: Result := 'lePlus';
    leComma: Result := 'leComma';
    leMinus: Result := 'leMinus';
    lePeriod: Result := 'lePeriod';
    leSlash: Result := 'leSlash';
    leNumber: Result := 'leNumber';
    leColon: Result := 'leColon';
    leSemicolon: Result := 'leSemicolon';
    leLess: Result := 'leLess';
    leEqual: Result := 'leEqual';
    leGreater: Result := 'leGreater';
    leQuestion: Result := 'leQuestion';
    leAtChar: Result := 'leAtChar';
    leSquareOpen: Result := 'leSquareOpen';
    leBackslash: Result := 'leBackslash';
    leSquareClose: Result := 'leSquareClose';
    leAsciiCircum: Result := 'leAsciiCircum';
    leQuoteLeft: Result := 'leQuoteLeft';
    leCurlyOpen: Result := 'leCurlyOpen';
    leBar: Result := 'leBar';
    leCurlyClose: Result := 'leCurlyClose';
    leAsciiTilde: Result := 'leAsciiTilde';

    leLineEnd: Result := 'leLineEnd';
    leIdentifier: Result := 'leIdentifier';
    leInternationalIdentifier: Result := 'leInternationalIdentifier';
    leUTF2Identifier: Result := 'leUTF2Identifier';
    leUTF4Identifier: Result := 'leUTF4Identifier';
    leUTF8Identifier: Result := 'leUTF8Identifier';
    leUTF16Identifier: Result := 'leUTF16Identifier';

    leAssignment: Result := 'leAssignment';
    leCharConstant: Result := 'leCharConstant';
    leCharHexConstant: Result := 'leCharHexConstant';
    leDotDot: Result := 'leDotDot';
    leDoubleAt: Result := 'leDoubleAt';
    leFloat: Result := 'leFloat';
    leGreaterOrEqual: Result := 'leGreaterOrEqual';
    leHexNumber: Result := 'leHexNumber';
    leLessOrEqual: Result := 'leLessOrEqual';
    leNotEqual: Result := 'leNotEqual';
    leStringConstant: Result := 'leStringConstant';
    leUnterminatedStringConstant: Result := 'leUnterminatedStringConstant';

    leAtEnd: Result := 'leAtEnd';
    leUnknown: Result := 'leUnknown';
    leDelphiBase: Result := 'leDelphiBase';
    leAnsiComment: Result := 'leAnsiComment';
    leAnsiDirective: Result := 'leAnsiDirective';
    leAssemblerReference: Result := 'leAssemblerReference';
    leBorlandComment: Result := 'leBorlandComment';
    leBorlandDirective: Result := 'leBorlandDirective';
    leEndOfAnsiComment: Result := 'leEndOfAnsiComment';
    leSkippedCode: Result := 'leSkippedCode';
    leSlashComment: Result := 'leSlashComment';
    leBeginOfAnsiDirective: Result := 'leBeginOfAnsiDirective';
    leBeginOfBorlandDirective: Result := 'leBeginOfBorlandDirective';

 {KeyWords}{KeyWords}
    leDelphiKeyWord: Result := 'leDelphiKeyWord';
    leAnd: Result := 'leAnd';
    leArray: Result := 'leArray';
    leAs: Result := 'leAs';
    leAsm: Result := 'leAsm';
    leBegin: Result := 'leBegin';
    leCase: Result := 'leCase';
    leClass: Result := 'leClass';
    leConst: Result := 'leConst';
    leConstructor: Result := 'leConstructor';
    leDestructor: Result := 'leDestructor';
    leDispinterface: Result := 'leDispinterface';
    leDiv: Result := 'leDiv';
    leDo: Result := 'leDo';
    leDownto: Result := 'leDownto';
    leElse: Result := 'leElse';
    leEnd: Result := 'leEnd';
    leExcept: Result := 'leExcept';
    leExports: Result := 'leExports';
    leFile: Result := 'leFile';
    leFinal: Result := 'leFinal';
    leFinalization: Result := 'leFinalization';
    leFinally: Result := 'leFinally';
    leFor: Result := 'leFor';
    leFunction: Result := 'leFunction';
    leGoto: Result := 'leGoto';
    leIf: Result := 'leIf';
    leImplementation: Result := 'leImplementation';
    leIn: Result := 'leIn';
    leInherited: Result := 'leInherited';
    leInitialization: Result := 'leInitialization';
    leInline: Result := 'leInline';
    leInterface: Result := 'leInterface';
    leIs: Result := 'leIs';
    leLabel: Result := 'leLabel';
    leLibrary: Result := 'leLibrary';
    leMod: Result := 'leMod';
    leNil: Result := 'leNil';
    leNot: Result := 'leNot';
    leObject: Result := 'leObject';
    leOf: Result := 'leOf';
    leOperator: Result := 'leOperator';
    leOr: Result := 'leOr';
    lePacked: Result := 'lePacked';
    leProcedure: Result := 'leProcedure';
    leProgram: Result := 'leProgram';
    leProperty: Result := 'leProperty';
    leRaise: Result := 'leRaise';
    leRecord: Result := 'leRecord';
    leRepeat: Result := 'leRepeat';
    leResourcestring: Result := 'leResourcestring';
    leSealed: Result := 'leSealed';
    leSet: Result := 'leSet';
    leShl: Result := 'leShl';
    leShr: Result := 'leShr';
    leString: Result := 'leString';
    leThen: Result := 'leThen';
    leThreadvar: Result := 'leThreadvar';
    leTo: Result := 'leTo';
    leTry: Result := 'leTry';
    leType: Result := 'leType';
    leUnit: Result := 'leUnit';
    leUntil: Result := 'leUntil';
    leUses: Result := 'leUses';
    leVar: Result := 'leVar';
    leWhile: Result := 'leWhile';
    leWith: Result := 'leWith';
    leXor: Result := 'leXor';

 {Directives}
    leDelphiDirective: Result := 'leDelphiDirective';
    leAbsolute: Result := 'leAbsolute';
    leAbstract: Result := 'leAbstract';
    leAssembler: Result := 'leAssembler';
    leAt: Result := 'leAt';
    leAutomated: Result := 'leAutomated';
    leCdecl: Result := 'leCdecl';
    leContains: Result := 'leContains';
    leDefault: Result := 'leDefault';
    leDeprecated: Result := 'leDeprecated';
    leDispid: Result := 'leDispid';
    leDynamic: Result := 'leDynamic';
    leExperimental: Result := 'leExperimental';
    leExport: Result := 'leExport';
    leExternal: Result := 'leExternal';
    leFar: Result := 'leFar';
    leForward: Result := 'leForward';
    leHelper: Result := 'leHelper';
    leImplements: Result := 'leImplements';
    leIndex: Result := 'leIndex';
    leLocal: Result := 'leLocal';
    leMessage: Result := 'leMessage';
    leName: Result := 'leName';
    leNear: Result := 'leNear';
    leNodefault: Result := 'leNodefault';
    leOn: Result := 'leOn';
    leOut: Result := 'leOut';
    leOverload: Result := 'leOverload';
    leOverride: Result := 'leOverride';
    lePackage: Result := 'lePackage';
    lePascal: Result := 'lePascal';
    lePlatform: Result := 'lePlatform';
    lePrivate: Result := 'lePrivate';
    leProtected: Result := 'leProtected';
    lePublic: Result := 'lePublic';
    lePublished: Result := 'lePublished';
    leRead: Result := 'leRead';
    leReadonly: Result := 'leReadonly';
    leRegister: Result := 'leRegister';
    leReintroduce: Result := 'leReintroduce';
    leRequires: Result := 'leRequires';
    leResident: Result := 'leResident';
    leSafecall: Result := 'leSafecall';
    leStatic: Result := 'leStatic';
    leStdcall: Result := 'leStdcall';
    leStored: Result := 'leStored';
    leStrict: Result := 'leStrict';
    leVarargs: Result := 'leVarargs';
    leVirtual: Result := 'leVirtual';
    leWrite: Result := 'leWrite';
    leWriteonly: Result := 'leWriteonly';

  {Additional}

    leA: Result := 'leA';
    leB: Result := 'leB';
    leC: Result := 'leC';
    leD: Result := 'leD';
    leE: Result := 'leE';
    leG: Result := 'leG';
    leH: Result := 'leH';
    leI: Result := 'leI';
    leJ: Result := 'leJ';
    leL: Result := 'leL';
    leM: Result := 'leM';
    leO: Result := 'leO';
    leP: Result := 'leP';
    leQ: Result := 'leQ';
    leR: Result := 'leR';
    leS: Result := 'leS';
    leT: Result := 'leT';
    leU: Result := 'leU';
    leV: Result := 'leV';
    leW: Result := 'leW';
    leX: Result := 'leX';
    leY: Result := 'leY';
    leZ: Result := 'leZ';
    leAndDirective: Result := 'leAndDirective';
    leOff: Result := 'leOff';
    leYD: Result := 'leYD';
    leOnDirective: Result := 'leOnDirective';
    leIfDirective: Result := 'leIfDirective';
    leIfDef: Result := 'leIfDef';
    leOrDirective: Result := 'leOrDirective';
    leGUI: Result := 'leGUI';
    leEndIf: Result := 'leEndIf';
    leIfEnd: Result := 'leIfEnd';
    leElseDirective: Result := 'leElseDirective';
    leDefine: Result := 'leDefine';
    leAlign: Result := 'leAlign';
    leIfNDef: Result := 'leIfNDef';
    leLink: Result := 'leLink';
    leDefined: Result := 'leDefined';
    leUnDef: Result := 'leUnDef';
    leDeclared: Result := 'leDeclared';
    leElseIf: Result := 'leElseIf';
    leImageBase: Result := 'leImageBase';
    leIfOpt: Result := 'leIfOpt';
    leSoName: Result := 'leSoName';
    leInclude: Result := 'leInclude';
    leHints: Result := 'leHints';
    leNoDefine: Result := 'leNoDefine';
    leIOChecks: Result := 'leIOChecks';
    leDebugInfo: Result := 'leDebugInfo';
    leConsole: Result := 'leConsole';
    leBooleval: Result := 'leBooleval';
    leHPPEmit: Result := 'leHPPEmit';
    leRangeChecks: Result := 'leRangeChecks';
    leNoInclude: Result := 'leNoInclude';
    leApptype: Result := 'leApptype';
    leSafeDivide: Result := 'leSafeDivide';
    leResource: Result := 'leResource';
    leWarn: Result := 'leWarn';
    leWarnings: Result := 'leWarnings';
    leTypeInfo: Result := 'leTypeInfo';
    leSoPrefix: Result := 'leSoPrefix';
    leStackFrames: Result := 'leStackFrames';
    leRunOnly: Result := 'leRunOnly';
    leSoSuffix: Result := 'leSoSuffix';
    leReferenceInfo: Result := 'leReferenceInfo';
    leDesignOnly: Result := 'leDesignOnly';
    leExtension: Result := 'leExtension';
    leImportedData: Result := 'leImportedData';
    leDescription: Result := 'leDescription';
    leSoVersion: Result := 'leSoVersion';
    leAssertions: Result := 'leAssertions';
    leImplicitBuild: Result := 'leImplicitBuild';
    leTypedAddress: Result := 'leTypedAddress';
    leLocalSymbols: Result := 'leLocalSymbols';
    leMinEnumSize: Result := 'leMinEnumSize';
    leWeakPackageUnit: Result := 'leWeakPackageUnit';
    leDefinitionInfo: Result := 'leDefinitionInfo';
    leMinStackSize: Result := 'leMinStackSize';
    leObjExportAll: Result := 'leObjExportAll';
    leMaxStackSize: Result := 'leMaxStackSize';
    leLongStrings: Result := 'leLongStrings';
    leDenyPackageUnit: Result := 'leDenyPackageUnit';
    leExternalSym: Result := 'leExternalSym';
    leOpenStrings: Result := 'leOpenStrings';
    leOverFlowChecks: Result := 'leOverFlowChecks';
    leWriteableConst: Result := 'leWriteableConst';
    leOptimization: Result := 'leOptimization';
    leVarStringChecks: Result := 'leVarStringChecks';
    leExtendedSyntax: Result := 'leExtendedSyntax';
    leRealCompatibility: Result := 'leRealCompatibility';
    leResourceReserve: Result := 'leResourceReserve';
    leRegion: Result := 'leRegion';
    leEndRegion: Result := 'leEndRegion';
    leStackChecks: Result := 'leStackChecks';
    leSymbol_Platform: Result := 'leSymbol_Platform';
    leSymbol_Library: Result := 'leSymbol_Library';
    leSymbol_Deprecated: Result := 'leSymbol_Deprecated';
    leUnit_Deprecated: Result := 'leUnit_Deprecated';
    leUnit_Library: Result := 'leUnit_Library';
    leUnit_Platform: Result := 'leUnit_Platform';
  end;
end;

end.

